package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.LotteryInfoActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemLotteryBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.LotteryJoinedResponse;
import app.firezone.synk.network.model.LotteryModel;


import java.util.ArrayList;

import android.widget.Toast;

import java.util.HashMap;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LotteryAdapter extends RecyclerView.Adapter<LotteryAdapter.holder> {

    Context mContext;
    ArrayList<LotteryModel> models = new ArrayList<LotteryModel>();

    private MyApi myApi;
    long userId;

    public LotteryAdapter(Context mContext, ArrayList<LotteryModel> models) {
        this.mContext = mContext;
        this.models = models;
        this.userId = SharedPrefManager.getInstance(mContext).getUserId();
    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_lottery, parent, false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, int position) {
        LotteryModel list = models.get(position);

        myApi = APIClient.getApiClient(mContext).create(MyApi.class);

        // Check if the user has joined the lottery using checkIfUserJoined API
        HashMap<String, Object> body = new HashMap<>();
        body.put("userId", userId);
        body.put("lotteryid", list.getId());

        Call<CheckJoinedResponse> call = myApi.checkIfUserJoined(body);
        call.enqueue(new Callback<CheckJoinedResponse>() {
            @Override
            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        holder.binding.btnText.setText("Played");
                    } else {
                        holder.binding.btnText.setText("Play Now");
                    }
                }
            }

            @Override
            public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                Toast.makeText(mContext, "Error checking lottery status: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });

        holder.binding.lotteryName.setText(list.getLotteryname());
        holder.binding.dateTxt.setText(list.getDate());
        holder.binding.timeTxt.setText(list.getTime());
        holder.binding.ratingTxt.setText(list.getRating());
        holder.binding.prizepool.setText("Win upto " + list.getPrize() + ".00 Rupees");

        Picasso.get().load(list.getImages()).placeholder(R.drawable.loading_img).into(holder.binding.imageView26);

        holder.itemView.setOnClickListener(view -> {
            Intent intent = new Intent(mContext, LotteryInfoActivity.class);
            intent.putExtra("lotteryId", String.valueOf(list.getId()));
            intent.putExtra("entryFee", list.getEntryfee());
            intent.putExtra("totalSeat", list.getTotalSeat());
            intent.putExtra("Prize", list.getPrize());
            mContext.startActivity(intent);
        });

        // Fetch and display number of joined users
        myApi = APIClient.getApiClient(mContext).create(MyApi.class);
        Call<LotteryJoinedResponse> joinedCall = myApi.fetchLotteryJoined(list.getId());
        joinedCall.enqueue(new Callback<LotteryJoinedResponse>() {
            @Override
            public void onResponse(Call<LotteryJoinedResponse> call, Response<LotteryJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {

                    if (response.body().isSuccess() && response.body().getData() != null) {
                        long child = response.body().getData().size();
                        long totalSeat = Long.parseLong(list.getTotalSeat());

                        holder.binding.joinedTxt.setText(child + "/" + list.getTotalSeat() + " Participants");

                        if (child >= totalSeat) {
                            holder.binding.btnText.setText("Full");
                        }
                    } else {
                        holder.binding.joinedTxt.setText("0/" + list.getTotalSeat() + " Participants");
                        holder.binding.btnText.setText("Play Now");
                    }
                } else {
                    Toast.makeText(mContext, "Failed to fetch data or invalid response", Toast.LENGTH_SHORT).show();
                }
            }


            @Override
            public void onFailure(Call<LotteryJoinedResponse> call, Throwable t) {
                Toast.makeText(mContext, "Error fetching joined users: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });


    }



    @Override
    public int getItemCount() {
        return models.size();
    }

    public class holder extends RecyclerView.ViewHolder {
        ItemLotteryBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = ItemLotteryBinding.bind(itemView);
        }
    }
}
